<?php
error_reporting(0);
ini_set('display_errors', 0);
session_start();

if (!isset($_SESSION['csrf_token'])) {
	$_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

define('DATA_FILE', __DIR__ . '/data.json');
define('UPLOAD_DIR', __DIR__ . '/uploads/');
if (!file_exists(UPLOAD_DIR)) { 
	mkdir(UPLOAD_DIR, 0755, true);
	createUploadHtaccess();
}

function createUploadHtaccess() {
	$htaccess = UPLOAD_DIR . '.htaccess';
	if (!file_exists($htaccess)) {
		$content = <<<'HTACCESS'
<FilesMatch "\.(php|php3|php4|php5|phtml)$">
	Order Deny,Allow
	Deny from all
</FilesMatch>
<FilesMatch "\.(jpg|jpeg|png|gif|webp)$">
	Order Allow,Deny
	Allow from all
</FilesMatch>
HTACCESS;
		file_put_contents($htaccess, $content);
	}
		}

function verifyCsrf() {
	if ($_SERVER['REQUEST_METHOD'] === 'POST') {
		if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
			die('不正なリクエストです');
		}
	}
		}

function loadData() {
	$defaults = [
	'auth' => ['username' => 'admin', 'password' => password_hash('admin123', PASSWORD_DEFAULT)],
	'site' => [
	'name' => 'マイリンク', 'description' => 'プロフィール文', 'bg_color' => '#2d3748', 
'profile_name_color' => '#000000',  
	'profile_desc_color' => '#000000',  
	'theme_color' => '#6c63ff', 'tweet_title' => '最新のつぶやき', 'tweet_count' => 1,
	'bg_image' => '', 'bg_opacity' => 0.5, 'profile_image' => '', 'ga_id' => '',
	'link_bg_color' => '#000000', 'link_bg_opacity' => 0.4,
	'tweet_bg_color' => '#000000', 'tweet_bg_opacity' => 0.4,
	'link_text_color' => '#ffffff', 'link_visited_color' => '#cccccc',
	'tweet_text_color' => '#ffffff', 'maintenance_image' => '',
	'maintenance_mode' => 'off',  'show_login_link' => 'on',
	'm_title' => '現在、メンテナンス中です',
	'm_text' => '恐れ入りますが、しばらく経ってから再度アクセスしてください。',
	'm_title_color' => '#ffffff', 'm_text_color' => '#8b949e',
	'image_title_bg_color' => '#000000', 'image_title_bg_opacity' => 0.8,
	'image_title_text_color' => '#ffffff'
   ,'favicon' => ''  
	,'site_icon' => '' 
	],
	'links' => [], 'tweets' => []
	];
	if (file_exists(DATA_FILE)) { 
		$data = json_decode(file_get_contents(DATA_FILE), true);
		return array_replace_recursive($defaults, $data);
	}
	return $defaults;
		}

function saveData($data) { 
	file_put_contents(DATA_FILE, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)); 
}

		function autoLinkUrls($text) {
	$text = htmlspecialchars($text, ENT_QUOTES, 'UTF-8');
	return preg_replace_callback(
		'/(https?:\/\/[^\s<]+)/i',
		function($matches) {
			$url = $matches[1];
			return '<a href="' . htmlspecialchars($url, ENT_QUOTES, 'UTF-8') . 
				   '" target="_blank" rel="noopener noreferrer" ' .
				   'style="color: var(--theme); text-decoration: none !important;">' . 
				   htmlspecialchars($url, ENT_QUOTES, 'UTF-8') . '</a>';
		},
		$text
	);
}

function handleUpload($fileKey, $oldFile = null) {
	if (!isset($_FILES[$fileKey]) || $_FILES[$fileKey]['error'] !== UPLOAD_ERR_OK) {
		return null;
	}
	
	$maxSize = 5 * 1024 * 1024;
	if ($_FILES[$fileKey]['size'] > $maxSize) {
		die('ファイルサイズが大きすぎます(最大5MB)');
	}
	
	$allowedExts = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
	$allowedMimes = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
	
	$ext = strtolower(pathinfo($_FILES[$fileKey]['name'], PATHINFO_EXTENSION));
	if (!in_array($ext, $allowedExts)) {
		die('許可されていないファイル形式です');
	}
	
	if (!in_array($_FILES[$fileKey]['type'], $allowedMimes)) {
		die('許可されていないファイル形式です');
	}
	
	$finfo = finfo_open(FILEINFO_MIME_TYPE);
	$actualMime = finfo_file($finfo, $_FILES[$fileKey]['tmp_name']);
	finfo_close($finfo);
	
	if (!in_array($actualMime, $allowedMimes)) {
		die('ファイルの内容が不正です');
	}
	
	$imageInfo = @getimagesize($_FILES[$fileKey]['tmp_name']);
	if ($imageInfo === false) {
		die('有効な画像ファイルではありません');
	}
	
	$maxWidth = 1200;
$maxHeight = 1200;
$cropToBanner = false; 

// ファビコンとサイトアイコンの場合はサイズを小さく
if ($fileKey === 'favicon') {
	$maxWidth = 32;
	$maxHeight = 32;
} elseif ($fileKey === 'site_icon') {
	$maxWidth = 180;
	$maxHeight = 180;
} elseif ($fileKey === 'banner_image_file') {
	// バナー画像は49:6の比率でトリミング
	$maxWidth = 1200;
	$maxHeight = 400;  
	$cropToBanner = true; 
}

$needsResize = ($imageInfo[0] > $maxWidth || $imageInfo[1] > $maxHeight) || $cropToBanner;  // 
	
	$filename = bin2hex(random_bytes(16)) . '.' . $ext;
	$destination = UPLOAD_DIR . $filename;
	
	if ($needsResize) {
		$srcImage = null;
		switch ($imageInfo[2]) {
			case IMAGETYPE_JPEG:
				$srcImage = @imagecreatefromjpeg($_FILES[$fileKey]['tmp_name']);
				break;
			case IMAGETYPE_PNG:
				$srcImage = @imagecreatefrompng($_FILES[$fileKey]['tmp_name']);
				break;
			case IMAGETYPE_GIF:
				$srcImage = @imagecreatefromgif($_FILES[$fileKey]['tmp_name']);
				break;
			case IMAGETYPE_WEBP:
				$srcImage = @imagecreatefromwebp($_FILES[$fileKey]['tmp_name']);
				break;
		}
		
		if ($srcImage) {
	$srcWidth = $imageInfo[0];
	$srcHeight = $imageInfo[1];
	
	// ← ここから追加
	if ($cropToBanner) {
		// バナー画像の場合は49:6の比率でトリミング
		$targetRatio = 3 / 1;  // 3.0
	$srcRatio = $srcWidth / $srcHeight;
		
		if ($srcRatio > $targetRatio) {
			// 横長すぎる場合：高さを基準にして横をトリミング
			$cropHeight = $srcHeight;
			$cropWidth = (int)($cropHeight * $targetRatio);
			$cropX = (int)(($srcWidth - $cropWidth) / 2);
			$cropY = 0;
		} else {
			// 縦長すぎる場合：幅を基準にして縦をトリミング
			$cropWidth = $srcWidth;
			$cropHeight = (int)($cropWidth / $targetRatio);
			$cropX = 0;
			$cropY = (int)(($srcHeight - $cropHeight) / 2);
		}
		
		// トリミング後のサイズを最大サイズに収める
		$ratio = min($maxWidth / $cropWidth, $maxHeight / $cropHeight);
		$newWidth = (int)($cropWidth * $ratio);
		$newHeight = (int)($cropHeight * $ratio);
		
		$dstImage = imagecreatetruecolor($newWidth, $newHeight);
		
		if ($imageInfo[2] == IMAGETYPE_PNG || $imageInfo[2] == IMAGETYPE_GIF) {
			imagealphablending($dstImage, false);
			imagesavealpha($dstImage, true);
			$transparent = imagecolorallocatealpha($dstImage, 255, 255, 255, 127);
			imagefilledrectangle($dstImage, 0, 0, $newWidth, $newHeight, $transparent);
		}
		
		// トリミングしながらリサイズ
		imagecopyresampled($dstImage, $srcImage, 0, 0, $cropX, $cropY, $newWidth, $newHeight, $cropWidth, $cropHeight);
		
	} else {
		// 通常の画像の場合（既存の処理）
		// ↑ ここまで追加
		
		$ratio = min($maxWidth / $srcWidth, $maxHeight / $srcHeight);
		$newWidth = (int)($srcWidth * $ratio);
		$newHeight = (int)($srcHeight * $ratio);
		
		$dstImage = imagecreatetruecolor($newWidth, $newHeight);
		
		if ($imageInfo[2] == IMAGETYPE_PNG || $imageInfo[2] == IMAGETYPE_GIF) {
			imagealphablending($dstImage, false);
			imagesavealpha($dstImage, true);
			$transparent = imagecolorallocatealpha($dstImage, 255, 255, 255, 127);
			imagefilledrectangle($dstImage, 0, 0, $newWidth, $newHeight, $transparent);
		}
			
			imagecopyresampled($dstImage, $srcImage, 0, 0, 0, 0, $newWidth, $newHeight, $srcWidth, $srcHeight);
			} 
			$success = false;
			switch ($imageInfo[2]) {
				case IMAGETYPE_JPEG:
					$success = imagejpeg($dstImage, $destination, 85);
					break;
				case IMAGETYPE_PNG:
					$success = imagepng($dstImage, $destination, 8);
					break;
				case IMAGETYPE_GIF:
					$success = imagegif($dstImage, $destination);
					break;
				case IMAGETYPE_WEBP:
					$success = imagewebp($dstImage, $destination, 85);
					break;
			}
			
			imagedestroy($srcImage);
			imagedestroy($dstImage);
			
			if ($success) {
				if ($oldFile && file_exists(__DIR__ . '/' . $oldFile)) {
					@unlink(__DIR__ . '/' . $oldFile);
				}
				return 'uploads/' . $filename;
			}
		}
	} else {
		if (move_uploaded_file($_FILES[$fileKey]['tmp_name'], $destination)) {
			if ($oldFile && file_exists(__DIR__ . '/' . $oldFile)) {
				@unlink(__DIR__ . '/' . $oldFile);
			}
			return 'uploads/' . $filename;
		}
	}
	
	return null;
}

$data = loadData();
$isLoggedIn = isset($_SESSION['logged_in']);
$page = $_GET['page'] ?? 'public';
$tab = $_GET['tab'] ?? 'settings';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
	verifyCsrf();
}

if ($page === 'login' && isset($_POST['login'])) {
	if ($_POST['user'] === $data['auth']['username'] && password_verify($_POST['pass'], $data['auth']['password'])) {
		$_SESSION['logged_in'] = true;
		header('Location: ?page=admin'); exit;
	} else { $login_error = "認証失敗"; }
}
if (isset($_GET['logout'])) { session_destroy(); header('Location: ./'); exit; }

if (!$isLoggedIn && $page === 'admin') {
	header('Location: ?page=login'); exit;
}

if (!$isLoggedIn && ($data['site']['maintenance_mode'] ?? 'off') === 'on' && $page !== 'login') {
	$page = 'maintenance';
}

if ($isLoggedIn) {
if (isset($_POST['save_site'])) {
	$keys = ['name','description','profile_name_color','profile_desc_color','bg_color','theme_color','tweet_title','tweet_count','bg_opacity','ga_id',
	'link_bg_color','link_bg_opacity','tweet_bg_color','tweet_bg_opacity',
		'link_text_color','link_visited_color','tweet_text_color','maintenance_mode','show_login_link','m_title','m_text','m_title_color','m_text_color',
		'image_title_bg_color','image_title_bg_opacity','image_title_text_color'];
		foreach($keys as $key) { $data['site'][$key] = $_POST[$key] ?? ($data['site'][$key] ?? ''); }
		if ($file = handleUpload('profile_image', $data['site']['profile_image'])) $data['site']['profile_image'] = $file;
		if ($file = handleUpload('bg_image', $data['site']['bg_image'])) $data['site']['bg_image'] = $file;
		if ($file = handleUpload('maintenance_image', $data['site']['maintenance_image'])) $data['site']['maintenance_image'] = $file;
        if ($file = handleUpload('favicon', $data['site']['favicon'])) $data['site']['favicon'] = $file;
	    if ($file = handleUpload('site_icon', $data['site']['site_icon'])) $data['site']['site_icon'] = $file;	
		saveData($data);
	}
	if (isset($_POST['update_auth'])) {
		if (!empty($_POST['new_user'])) { $data['auth']['username'] = $_POST['new_user']; }
		if (!empty($_POST['new_pass'])) { $data['auth']['password'] = password_hash($_POST['new_pass'], PASSWORD_DEFAULT); }
		$data['site']['show_login_link'] = $_POST['show_login_link'] ?? 'on';
		saveData($data); $auth_message = "更新しました。";
	}
	if (isset($_GET['reset_m'])) { 
		$data['site']['m_title'] = '現在、メンテナンス中です'; 
		$data['site']['m_text'] = '恐れ入りますが、しばらく経ってから再度アクセスしてください。'; 
		$data['site']['m_title_color'] = '#ffffff'; 
		$data['site']['m_text_color'] = '#8b949e'; 
		saveData($data); 
		header('Location: ?page=admin&tab=settings'); exit; 
	}
	if (isset($_GET['del_img'])) { 
	$type = $_GET['del_img']; 
	// ↓ この行を変更
	$imgKey = ($type==='profile'?'profile_image':($type==='bg'?'bg_image':($type==='favicon'?'favicon':($type==='site_icon'?'site_icon':'maintenance_image'))));
	
	if(!empty($data['site'][$imgKey])) { 
		@unlink(__DIR__.'/'.$data['site'][$imgKey]); 
		$data['site'][$imgKey] = ''; 
		saveData($data); 
	}
	header('Location: ?page=admin&tab=settings'); exit; 
}
	if (isset($_POST['save_link'])) {
	$id = $_POST['link_id']; 
	$type = $_POST['link_type'];
	$existing = null; 
	$foundIndex = -1;
	foreach($data['links'] as $idx => $l) { 
		if($l['id'] === $id) { 
			$existing = $l; 
			$foundIndex = $idx; 
		} 
	}
	
$newLink = [
	'id' => $id ?: uniqid(), 
	'type' => $type, 
	'title' => $_POST['link_title'] ?? '', 
	'url' => $_POST['link_url'] ?? '', 
	'accent_color' => $_POST['accent_color'] ?? $data['site']['theme_color'],
	'show_title' => $_POST['show_title'] ?? 'on',  // 
	'icon' => $existing['icon'] ?? '🔗', 
		'normal_image' => $existing['normal_image'] ?? '', 
		'banner_image' => $existing['banner_image'] ?? '', 
		'emoji' => $_POST['link_emoji'] ?? '', 
		'triple_icon1' => $existing['triple_icon1'] ?? '', 
		'triple_icon2' => $existing['triple_icon2'] ?? '', 
		'triple_icon3' => $existing['triple_icon3'] ?? '',
		'triple_title1' => $_POST['triple_title1'] ?? '',
		'triple_title2' => $_POST['triple_title2'] ?? '',
		'triple_title3' => $_POST['triple_title3'] ?? '',
		'triple_url1' => $_POST['triple_url1'] ?? '',
		'triple_url2' => $_POST['triple_url2'] ?? '',
		'triple_url3' => $_POST['triple_url3'] ?? ''
	];
		
		if ($type === 'standard') {
			$iconFile = handleUpload('link_icon', (strpos($existing['icon']??'','uploads/')===0 ? $existing['icon'] : null));
			if ($iconFile) {
				$newLink['icon'] = $iconFile;
			} elseif (!empty($_POST['link_emoji'])) {
				$newLink['icon'] = $_POST['link_emoji'];
			}
		} elseif ($type === 'normal_img') {
			$normalImg = handleUpload('normal_image_file', $existing['normal_image'] ?? null);
			if ($normalImg) $newLink['normal_image'] = $normalImg;
		} elseif ($type === 'banner') {
			$bannerImg = handleUpload('banner_image_file', $existing['banner_image'] ?? null);
			if ($bannerImg) $newLink['banner_image'] = $bannerImg;
		} elseif ($type === 'triple_icon') {
			$icon1 = handleUpload('triple_icon1_file', $existing['triple_icon1'] ?? null);
			if ($icon1) $newLink['triple_icon1'] = $icon1;
			$icon2 = handleUpload('triple_icon2_file', $existing['triple_icon2'] ?? null);
			if ($icon2) $newLink['triple_icon2'] = $icon2;
			$icon3 = handleUpload('triple_icon3_file', $existing['triple_icon3'] ?? null);
			if ($icon3) $newLink['triple_icon3'] = $icon3;
		}
		
		if ($foundIndex !== -1) { 
			$data['links'][$foundIndex] = $newLink; 
		} else { 
			$data['links'][] = $newLink; 
		}
		saveData($data); 
		header('Location: ?page=admin&tab=links'); exit;
	}
	if (isset($_POST['save_tweet'])) {
		$tid = $_POST['tweet_id'];
		if ($tid) { 
			foreach($data['tweets'] as &$t) { 
				if($t['id'] === $tid) $t['content'] = $_POST['tweet_content']; 
			}
		} else { 
			$data['tweets'][] = ['id'=>uniqid(), 'content'=>$_POST['tweet_content'], 'timestamp'=>time()]; 
		}
		saveData($data); 
		header('Location: ?page=admin&tab=tweets'); exit;
	}
	if (isset($_GET['delete_link'])) { 
		$id = $_GET['delete_link']; 
		$data['links'] = array_values(array_filter($data['links'], function($l) use ($id) { 
			return $l['id'] !== $id; 
		})); 
		saveData($data); 
		header('Location: ?page=admin&tab=links'); exit; 
	}
	if (isset($_GET['delete_tweet'])) { 
		$id = $_GET['delete_tweet']; 
		$data['tweets'] = array_values(array_filter($data['tweets'], function($t) use ($id) { 
			return $t['id'] !== $id; 
		})); 
		saveData($data); 
		header('Location: ?page=admin&tab=tweets'); exit; 
	}
	if (isset($_POST['new_order'])) { 
		$order = explode(',', $_POST['new_order']); 
		$newLinks = []; 
		foreach($order as $oid){ 
			foreach($data['links'] as $ol){ 
				if($ol['id']===$oid) $newLinks[]=$ol; 
			} 
		} 
		$data['links']=$newLinks; 
		saveData($data); exit; 
	}
}

function hex2rgba($hex, $opacity) {
	$hex = preg_replace("/[^0-9a-fA-F]/", "", $hex);
	if(strlen($hex) == 3) { 
		$r = hexdec(substr($hex,0,1).substr($hex,0,1)); 
		$g = hexdec(substr($hex,1,1).substr($hex,1,1)); 
		$b = hexdec(substr($hex,2,1).substr($hex,2,1)); 
	} elseif(strlen($hex) == 6) { 
		$r = hexdec(substr($hex,0,2)); 
		$g = hexdec(substr($hex,2,2)); 
		$b = hexdec(substr($hex,4,2)); 
	} else { 
		$r=0;$g=0;$b=0; 
	}
	return "rgba($r, $g, $b, $opacity)";
}
$link_bg_final = hex2rgba($data['site']['link_bg_color'] ?? '#000000', $data['site']['link_bg_opacity'] ?? 0.4);
$tweet_bg_final = hex2rgba($data['site']['tweet_bg_color'] ?? '#000000', $data['site']['tweet_bg_opacity'] ?? 0.4);
$image_title_bg_final = hex2rgba($data['site']['image_title_bg_color'] ?? '#000000', $data['site']['image_title_bg_opacity'] ?? 0.8);
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?= htmlspecialchars($data['site']['name']) ?></title>
<?php if(!empty($data['site']['favicon'])): ?>
<link rel="icon" type="image/x-icon" href="<?= htmlspecialchars($data['site']['favicon']) ?>">
<?php endif; ?>

<?php if(!empty($data['site']['site_icon'])): ?>
<link rel="apple-touch-icon" href="<?= htmlspecialchars($data['site']['site_icon']) ?>">
<?php endif; ?>


<?php if(!empty($data['site']['ga_id'])): ?>
<script async src="https://www.googletagmanager.com/gtag/js?id=<?= $data['site']['ga_id'] ?>"></script>
<script>window.dataLayer=window.dataLayer||[];function gtag(){dataLayer.push(arguments);}gtag('js',new Date());gtag('config','<?= $data['site']['ga_id'] ?>');</script>
<?php endif; ?>
<style>
<?php if ($isLoggedIn && $page === 'admin'): ?>
:root { 
	--theme: #6c63ff; 
	--link-bg: rgba(0, 0, 0, 0.4); 
	--tweet-bg: rgba(0, 0, 0, 0.4); 
	--link-text: #ffffff; 
	--visited-color: #cccccc; 
	--tweet-text: #ffffff; 
	--image-title-bg: rgba(0, 0, 0, 0.8);
	--image-title-text: #ffffff;
}
<?php else: ?>
:root { 
	--theme: <?= $data['site']['theme_color'] ?>; 
	--link-bg: <?= $link_bg_final ?>; 
	--tweet-bg: <?= $tweet_bg_final ?>; 
	--link-text: <?= $data['site']['link_text_color'] ?>; 
	--visited-color: <?= $data['site']['link_visited_color'] ?>; 
	--tweet-text: <?= $data['site']['tweet_text_color'] ?>; 
	--image-title-bg: <?= $image_title_bg_final ?>;
	--image-title-text: <?= $data['site']['image_title_text_color'] ?>;
}
<?php endif; ?>

* { margin: 0; padding: 0; box-sizing: border-box; }
body { font-family: -apple-system, sans-serif; background: #17323e; color: white; line-height: 1.6; }
input, textarea, select { width: 100%; padding: 12px; background: #0d1117; border: 1px solid #30363d; color: white; border-radius: 8px; margin-bottom: 10px; font-size: 16px; }
label { font-size: 11px; color: #8b949e; display: block; margin-bottom: 4px; margin-top: 12px; font-weight: bold; }
.btn { padding: 12px; border: none; border-radius: 8px; cursor: pointer; color: white; font-weight: bold; font-size: 14px; flex: 1; text-align: center; text-decoration: none; display: flex; align-items: center; justify-content: center; }
.btn-save { background: #6c63ff; }
		.btn-preview { background: #238636; }
.admin-layout { max-width: 600px; margin: 0 auto; background: #161b22; min-height: 100vh; padding: 20px; border-left: 1px solid #30363d; border-right: 1px solid #30363d; padding-bottom: 100px; }
.nav-tabs { display: flex; gap: 15px; margin-bottom: 25px; border-bottom: 1px solid #30363d; padding-bottom: 10px; overflow-x: auto; }
.nav-tabs a { color: #8b949e; text-decoration: none; font-size: 14px; white-space: nowrap; }
.nav-tabs a.active { color: white; font-weight: bold; border-bottom: 2px solid #6c63ff; }
.section-title { margin-top: 30px; margin-bottom: 10px; font-size: 14px; border-bottom: 1px solid #30363d; padding-bottom: 5px; color: #6c63ff; }
.public-view { position: relative; min-height: 100vh; padding: 40px 0; background-color: <?= $data['site']['bg_color'] ?>; background-image: url('<?= $data['site']['bg_image'] ?>'); background-size: cover; background-position: center; background-attachment: fixed; }
.bg-overlay { position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: <?= $data['site']['bg_color'] ?>; opacity: <?= $data['site']['bg_opacity'] ?>; z-index: 1; }
.container { position: relative; z-index: 2; max-width: 500px; margin: 0 auto; padding: 0 15px; }
.profile { text-align: center; margin-bottom: 30px; }
.profile-img { width: 90px; height: 90px; border-radius: 50%; border: 3px solid var(--theme); object-fit: cover; margin-bottom: 15px; }
.profile h1 { color: #000; font-weight: bold; }
.link-item { display: block; margin-bottom: 12px; border-radius: 12px; overflow: hidden; background: var(--link-bg); backdrop-filter: blur(8px); border: 1px solid rgba(255,255,255,0.1); color: var(--link-text); text-decoration: none; transition: all 0.3s ease; }
.link-item:hover { transform: translateY(-2px); box-shadow: 0 4px 12px rgba(0,0,0,0.3); border-color: rgba(255,255,255,0.2); }
.link-item.no-link { cursor: default; pointer-events: none; }
.link-item.no-link:hover { transform: none; box-shadow: none; border-color: rgba(255,255,255,0.1); }
.card-standard { display: flex; align-items: center; padding: 14px; border-left: 5px solid var(--acc, var(--theme)); transition: padding-left 0.3s ease; }
.link-item:hover .card-standard { padding-left: 18px; }
.link-item.no-link:hover .card-standard { padding-left: 14px; }
.link-item:hover img { transform: scale(1.02); }
.link-item.no-link:hover img { transform: none; }
.link-icon { width: 32px; height: 32px; margin-right: 12px; font-size: 20px; display: flex; align-items: center; justify-content: center; overflow: hidden; }
#back-to-top { position: fixed; bottom: 20px; right: 20px; width: 40px; height: 40px; border-radius: 50%; background: var(--theme); color: white; display: flex; align-items: center; justify-content: center; opacity: 0; visibility: hidden; transition: 0.3s; border: none; cursor: pointer; z-index: 100; }
#back-to-top.show { opacity: 1; visibility: visible; }
.tweet-box { background: var(--tweet-bg); backdrop-filter: blur(8px); padding: 18px; border-radius: 12px; margin-bottom: 20px; color: var(--tweet-text); border: 1px solid rgba(255,255,255,0.1); }
.image-title-overlay { position: absolute; bottom: 0; left: 0; width: 100%; padding: 6px; font-size: 13px; font-weight: bold; text-align: center; background: var(--image-title-bg); backdrop-filter: blur(4px); color: var(--image-title-text); pointer-events: none; }
.triple-icon-container { display: grid; grid-template-columns: repeat(3, 1fr); gap: 8px; padding: 10px; }
.triple-icon-item { position: relative; aspect-ratio: 1; border-radius: 12px; overflow: hidden; background: rgba(255,255,255,0.05); transition: all 0.3s ease; }
.triple-icon-item img { width: 100%; height: 100%; object-fit: cover; display: block; }
.triple-icon-item:hover { transform: scale(1.05); }
.triple-icon-title { position: absolute; bottom: 0; left: 0; width: 100%; padding: 4px; font-size: 10px; font-weight: bold; text-align: center; background: var(--link-bg); color: var(--link-text); }
</style>
</head>
<body>

<?php if ($isLoggedIn && $page === 'admin'): ?>
<div class="admin-layout">
<div class="nav-tabs">
<a href="?page=admin&tab=settings" class="<?= $tab=='settings'?'active':'' ?>">全般設定</a>
<a href="?page=admin&tab=links" class="<?= $tab=='links'?'active':'' ?>">リンク管理</a>
<a href="?page=admin&tab=tweets" class="<?= $tab=='tweets'?'active':'' ?>">つぶやき</a>
<a href="?page=admin&tab=security" class="<?= $tab=='security'?'active':'' ?>">セキュリティ</a>
</div>

<?php if($tab === 'settings'): ?>
<form method="post" enctype="multipart/form-data">
<input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
<div style="display:flex;gap:10px;margin-bottom:20px;position:sticky;top:0;background:#17323e;padding:10px 0;z-index:10;">
<button type="submit" name="save_site" class="btn btn-save">設定を保存</button>
<a href="./" target="_blank" class="btn btn-preview">表示を確認</a>
</div>

<div class="section-title">基本プロフィール</div>
<label>サイト名</label>
<input type="text" name="name" value="<?= htmlspecialchars($data['site']['name']) ?>">
<label>説明文</label>
<textarea name="description" rows="3"><?= htmlspecialchars($data['site']['description']) ?></textarea>
<div class="section-title">🎨 プロフィール文字色</div>
<div style="display:grid; grid-template-columns: 1fr 1fr; gap:10px;">
<div>
	<label>サイト名の文字色</label>
	<input type="color" name="profile_name_color" value="<?= $data['site']['profile_name_color'] ?? '#000000' ?>">
</div>
<div>
	<label>説明文の文字色</label>
	<input type="color" name="profile_desc_color" value="<?= $data['site']['profile_desc_color'] ?? '#000000' ?>">
</div>
</div>
<label>プロフ画像</label>
<?php if(!empty($data['site']['profile_image'])): ?>
<div style="display:flex; align-items:center; gap:10px; margin-bottom:10px;">
<img src="<?= $data['site']['profile_image'] ?>" style="width:40px;height:40px;border-radius:50%;">
<a href="?page=admin&del_img=profile" style="padding:4px 12px; background:#da3633; color:white; border:1px solid #da3633; border-radius:4px; text-decoration:none; font-size:12px; display:inline-block;">削除</a>
</div>
<?php endif; ?>
<input type="file" name="profile_image">

<div class="section-title">🎨 ファビコン・サイトアイコン</div>
<label>ファビコン (16x16 または 32x32 推奨)</label>
<?php if(!empty($data['site']['favicon'])): ?>
<div style="display:flex; align-items:center; gap:10px; margin-bottom:10px;">
<img src="<?= $data['site']['favicon'] ?>" style="width:32px;height:32px;">
<a href="?page=admin&del_img=favicon" style="padding:4px 12px; background:#da3633; color:white; border:1px solid #da3633; border-radius:4px; text-decoration:none; font-size:12px; display:inline-block;">削除</a>
</div>
<?php endif; ?>
<input type="file" name="favicon">

<label>サイトアイコン / Apple Touch Icon (180x180 推奨)</label>
<?php if(!empty($data['site']['site_icon'])): ?>
<div style="display:flex; align-items:center; gap:10px; margin-bottom:10px;">
<img src="<?= $data['site']['site_icon'] ?>" style="width:60px;height:60px;border-radius:8px;">
<a href="?page=admin&del_img=site_icon" style="padding:4px 12px; background:#da3633; color:white; border:1px solid #da3633; border-radius:4px; text-decoration:none; font-size:12px; display:inline-block;">削除</a>
</div>
<?php endif; ?>
<input type="file" name="site_icon">

<div class="section-title">背景・全体カラー</div>
<label>背景画像</label>
<?php if(!empty($data['site']['bg_image'])): ?>
<div style="display:flex; align-items:center; gap:10px; margin-bottom:10px;">
<img src="<?= $data['site']['bg_image'] ?>" style="width:60px;height:40px; border-radius:4px;">
<a href="?page=admin&del_img=bg" style="padding:4px 12px; background:#da3633; color:white; border:1px solid #da3633; border-radius:4px; text-decoration:none; font-size:12px; display:inline-block;">削除</a>
</div>
<?php endif; ?>
<input type="file" name="bg_image">
<div style="display:grid; grid-template-columns: 1fr 1fr; gap:10px;">
<div><label>背景色</label><input type="color" name="bg_color" value="<?= $data['site']['bg_color'] ?>"></div>
<div><label>背景不透明度</label><input type="range" name="bg_opacity" min="0" max="1" step="0.1" value="<?= $data['site']['bg_opacity'] ?>"></div>
</div>
<label>テーマカラー</label>
<input type="color" name="theme_color" value="<?= $data['site']['theme_color'] ?>">

<div class="section-title">リンクパーツ設定</div>
<div style="display:grid; grid-template-columns: 1fr 1fr; gap:10px;">
<div><label>リンク背景色</label><input type="color" name="link_bg_color" value="<?= $data['site']['link_bg_color'] ?>"></div>
<div><label>背景透過度</label><input type="range" name="link_bg_opacity" min="0" max="1" step="0.1" value="<?= $data['site']['link_bg_opacity'] ?>"></div>
<div><label>文字色</label><input type="color" name="link_text_color" value="<?= $data['site']['link_text_color'] ?>"></div>
<div><label>訪問済みリンク色</label><input type="color" name="link_visited_color" value="<?= $data['site']['link_visited_color'] ?>"></div>
</div>

<div class="section-title">🖼️ 画像・バナーリンクのタイトル設定</div>
<div style="display:grid; grid-template-columns: 1fr 1fr; gap:10px;">
<div><label>タイトル背景色</label><input type="color" name="image_title_bg_color" value="<?= $data['site']['image_title_bg_color'] ?? '#000000' ?>"></div>
<div><label>背景透過度</label><input type="range" name="image_title_bg_opacity" min="0" max="1" step="0.1" value="<?= $data['site']['image_title_bg_opacity'] ?? 0.8 ?>"></div>
</div>
<label>タイトル文字色</label>
<input type="color" name="image_title_text_color" value="<?= $data['site']['image_title_text_color'] ?? '#ffffff' ?>">

<div class="section-title">つぶやき表示設定</div>
<label>つぶやき見出し</label>
<input type="text" name="tweet_title" value="<?= htmlspecialchars($data['site']['tweet_title']) ?>">
<div style="display:grid; grid-template-columns: 1fr 1fr; gap:10px;">
<div><label>つぶやき背景色</label><input type="color" name="tweet_bg_color" value="<?= $data['site']['tweet_bg_color'] ?>"></div>
<div><label>背景透過度</label><input type="range" name="tweet_bg_opacity" min="0" max="1" step="0.1" value="<?= $data['site']['tweet_bg_opacity'] ?>"></div>
<div><label>文字色</label><input type="color" name="tweet_text_color" value="<?= $data['site']['tweet_text_color'] ?>"></div>
<div><label>表示件数</label><input type="number" name="tweet_count" value="<?= $data['site']['tweet_count'] ?>" min="1" max="10"></div>
</div>

<div class="section-title">🚧 工事中モード設定</div>
<label>モード切替</label>
<select name="maintenance_mode">
<option value="off" <?= ($data['site']['maintenance_mode']??'off')==='off'?'selected':'' ?>>通常公開</option>
<option value="on" <?= ($data['site']['maintenance_mode']??'off')==='on'?'selected':'' ?>>工事中画面を表示</option>
</select>
<label>工事中画像</label>
<?php if(!empty($data['site']['maintenance_image'])): ?>
<div style="margin-bottom:10px;">
<img src="<?= $data['site']['maintenance_image'] ?>" style="max-width:200px; border-radius:8px; display:block; margin-bottom:8px;">
<a href="?page=admin&del_img=mt" style="padding:4px 12px; background:#da3633; color:white; border:1px solid #da3633; border-radius:4px; text-decoration:none; font-size:12px; display:inline-block;">画像を削除</a>
</div>
<?php endif; ?>
<input type="file" name="maintenance_image">
<label>見出し</label>
<input type="text" name="m_title" value="<?= htmlspecialchars($data['site']['m_title']) ?>">
<label>メッセージ</label>
<textarea name="m_text" rows="2"><?= htmlspecialchars($data['site']['m_text']) ?></textarea>
<div style="display:grid; grid-template-columns: 1fr 1fr; gap:10px;">
<div><label>見出し文字色</label><input type="color" name="m_title_color" value="<?= $data['site']['m_title_color'] ?? '#ffffff' ?>"></div>
<div><label>メッセージ文字色</label><input type="color" name="m_text_color" value="<?= $data['site']['m_text_color'] ?? '#8b949e' ?>"></div>
</div>
<a href="?reset_m=1" style="color:#6c63ff; font-size:12px; text-decoration:none;">🔙工事中メッセージをデフォルトに戻す</a>

<div class="section-title">📊 外部連携</div>
<label>Googleアナリティクス 測定ID (G-XXXXXXXXXX)</label>
<input type="text" name="ga_id" value="<?= htmlspecialchars($data['site']['ga_id']) ?>" placeholder="G-XXXXXXXXXX">
</form>

<?php elseif($tab === 'links'): ?>
<div style="display:flex;gap:10px;margin-bottom:20px;">
<button type="submit" form="link_form" name="save_link" class="btn btn-save">リンクを保存</button>
</div>
<form method="post" enctype="multipart/form-data" id="link_form">
<input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
<input type="hidden" name="link_id" id="l_id">
<label>形式</label>
<select name="link_type" id="l_type" onchange="u(this.value)">
<option value="standard">通常</option>
<option value="normal_img">画像</option>
<option value="banner">バナー</option>
<option value="triple_icon">3アイコン横並び</option>
</select>

<div id="common_fields">
<label>タイトル</label>
<input type="text" name="link_title" id="l_title" placeholder="タイトル">
<label>URL</label>
<input type="url" name="link_url" id="l_url" placeholder="URL (空欄の場合はリンクなし)">
</div>

<!-- ↓ この行を変更（display:block を display:none に） -->
<div id="title_display_option" style="display:none;">
<label>画像・バナーのタイトル表示</label>
<select name="show_title" id="l_show_title">
<option value="on">表示する</option>
<option value="off">非表示</option>
</select>
<p style="font-size:11px; color:#8b949e; margin-top:-5px;">※画像・バナー形式の場合のみ有効(非表示の場合、一覧表示にだけ表示される)</p>
</div>

<div id="b1" style="display:block;">
<label>絵文字またはアイコン</label>
<input type="text" name="link_emoji" id="l_emoji" placeholder="絵文字を入力 (例: 🔗)">
<label>またはアイコン画像をアップロード</label>
<div id="current_icon" style="font-size:11px; color:#8b949e; margin-bottom:5px;"></div>
<input type="file" name="link_icon">
</div>

<div id="b2" style="display:none;">
<label>通常画像</label>
<div id="current_normal_img" style="font-size:11px; color:#8b949e; margin-bottom:5px;"></div>
<input type="file" name="normal_image_file">
</div>
<div id="b3" style="display:none;">
<label>バナー画像</label>
<div id="current_banner_img" style="font-size:11px; color:#8b949e; margin-bottom:5px;"></div>
<input type="file" name="banner_image_file">
</div>
<div id="b5" style="display:none;">
<div style="background:#0d1117; padding:15px; border-radius:8px; margin-bottom:15px;">
<label>📍 アイコン1(左)</label>
<div id="current_triple1" style="font-size:11px; color:#8b949e; margin-bottom:5px;"></div>
<input type="file" name="triple_icon1_file">
<label>タイトル1</label>
<input type="text" name="triple_title1" id="triple_title1" placeholder="アイコン1のタイトル">
<label>URL1</label>
<input type="url" name="triple_url1" id="triple_url1" placeholder="アイコン1のURL (空欄可)">
</div>

<div style="background:#0d1117; padding:15px; border-radius:8px; margin-bottom:15px;">
<label>📍 アイコン2(中央)</label>
<div id="current_triple2" style="font-size:11px; color:#8b949e; margin-bottom:5px;"></div>
<input type="file" name="triple_icon2_file">
<label>タイトル2</label>
<input type="text" name="triple_title2" id="triple_title2" placeholder="アイコン2のタイトル">
<label>URL2</label>
<input type="url" name="triple_url2" id="triple_url2" placeholder="アイコン2のURL (空欄可)">
</div>

<div style="background:#0d1117; padding:15px; border-radius:8px; margin-bottom:15px;">
<label>📍 アイコン3(右)</label>
<div id="current_triple3" style="font-size:11px; color:#8b949e; margin-bottom:5px;"></div>
<input type="file" name="triple_icon3_file">
<label>タイトル3</label>
<input type="text" name="triple_title3" id="triple_title3" placeholder="アイコン3のタイトル">
<label>URL3</label>
<input type="url" name="triple_url3" id="triple_url3" placeholder="アイコン3のURL (空欄可)">
</div>
</div>

<div id="b4">
<label>個別アクセントカラー</label>
<div style="display:flex; gap:10px;">
<input type="color" name="accent_color" id="l_accent" value="<?= $data['site']['theme_color'] ?>" style="flex:1;">
<button type="button" onclick="resetAccentColor()" style="padding:12px 20px; background:#30363d; color:white; border:1px solid #30363d; border-radius:8px; cursor:pointer; white-space:nowrap;">リセット</button>
</div>
</div>
<button type="button" id="l_reset_btn" onclick="resetLinkForm()" style="display:none; width:100%; padding:10px; margin-top:5px; background:#333; color:white; border:none; border-radius:8px;">編集をキャンセル</button>
</form>
<div id="sortable-links" style="margin-top:20px;">
<?php foreach ($data['links'] as $l): ?>
<div class="sort-item" data-id="<?= $l['id'] ?>" style="background:#0d1117; padding:10px; border:1px solid #333; margin-bottom:5px; display:flex; justify-content:space-between; align-items:center; border-radius:8px;">
<div style="display:flex; align-items:center;">
<div class="handle" style="cursor:grab; padding-right:15px;">☰</div>
<span><?php 
if ($l['type'] === 'triple_icon') {
	echo '3アイコン';
} else {
	echo htmlspecialchars($l['title'] ?: '画像リンク');
}
?></span>
<?php if(($l['type'] === 'normal_img' || $l['type'] === 'banner') && isset($l['show_title']) && $l['show_title'] === 'off'): ?>
<span style="font-size:10px; color:#8b949e; margin-left:8px;">(🔒タイトル非表示)</span>
<?php endif; ?>
</div>
<div style="display:flex; gap:5px;">
<button onclick='editLink(<?= json_encode($l) ?>)' style="padding:5px 10px; background:#1f6feb; color:#fff; border:1px solid #1f6feb; border-radius:4px; cursor:pointer;">編集</button>
<a href="?page=admin&tab=links&delete_link=<?= $l['id'] ?>" onclick="return confirm('削除しますか?')" style="padding:5px 10px; background:#da3633; color:#fff; border:1px solid #da3633; border-radius:4px; cursor:pointer; text-decoration:none; display:inline-block;">削除</a>
</div>
</div>
<?php endforeach; ?>
</div>

<?php elseif($tab === 'tweets'): ?>
<div style="display:flex;gap:10px;margin-bottom:20px;">
<button type="submit" form="tweet_form" name="save_tweet" class="btn btn-save">投稿を保存</button>
</div>
<form method="post" id="tweet_form">
<input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
<input type="hidden" name="tweet_id" id="t_id">
<textarea name="tweet_content" id="t_content" required rows="4" placeholder="いまどうしてる?"></textarea>
<button type="button" id="t_reset_btn" onclick="resetTweetForm()" style="display:none; width:100%; padding:10px; margin-top:5px; background:#333; color:white; border:none; border-radius:8px;">キャンセル</button>
</form>
<?php foreach (array_reverse($data['tweets']) as $t): ?>
<div style="background:#0d1117; padding:15px; border:1px solid #333; margin-top:10px; border-radius:8px;">
<div style="font-size:11px; color:#8b949e; margin-bottom:8px;"><?= date('Y年m月d日 H:i', $t['timestamp'] ?? time()) ?></div>
<div style="font-size:14px; margin-bottom:10px;"><?= nl2br(htmlspecialchars($t['content'])) ?></div>
<div style="text-align:right; display:flex; gap:5px; justify-content:flex-end;">
<button onclick='editTweet(<?= json_encode($t) ?>)' style="padding:4px 8px; font-size:12px; background:#1f6feb; border:1px solid #1f6feb; color:white; border-radius:4px; cursor:pointer;">編集</button>
<a href="?page=admin&tab=tweets&delete_tweet=<?= $t['id'] ?>" onclick="return confirm('削除しますか?')" style="padding:4px 8px; font-size:12px; background:#da3633; color:white; border:1px solid #da3633; border-radius:4px; text-decoration:none; display:inline-block; cursor:pointer;">削除</a>
</div>
</div>
<?php endforeach; ?>

<?php elseif($tab === 'security'): ?>
<form method="post">
<input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
<div style="display:flex;gap:10px;margin-bottom:20px;">
<button type="submit" name="update_auth" class="btn btn-save">ログイン情報を更新</button>
</div>
<?php if(isset($auth_message)): ?>
<div style="background:#238636; color:white; padding:10px; border-radius:8px; margin-bottom:20px; font-size:14px;"><?= $auth_message ?></div>
<?php endif; ?>

<div class="section-title">🔒 ログイン認証情報</div>
<label>新しいユーザー名 (現在: <?= htmlspecialchars($data['auth']['username']) ?>)</label>
<input type="text" name="new_user" placeholder="変更する場合のみ入力">
<label>新しいパスワード</label>
<input type="password" name="new_pass" placeholder="変更する場合のみ入力">

<div class="section-title">🔐 セキュリティ表示設定</div>
<label>フッターのLoginリンク表示</label>
<select name="show_login_link">
<option value="on" <?= ($data['site']['show_login_link']??'on')==='on'?'selected':'' ?>>表示する</option>
<option value="off" <?= ($data['site']['show_login_link']??'on')==='off'?'selected':'' ?>>非表示(セキュリティ強化)</option>
</select>
<p style="font-size:11px; color:#8b949e; margin-top:5px;">※非表示にした場合は、URLに直接 ?page=login を追加してログインしてください</p>
</form>
<?php endif; ?>
<a href="?logout=1" style="display:block; text-align:center; margin-top:50px; color:#8b949e; font-size:12px;">ログアウト</a>
</div>

<?php elseif($page === 'maintenance'): ?>
<div style="text-align:center; padding:100px 20px; background:<?= $data['site']['bg_color'] ?>; min-height:100vh; display:flex; flex-direction:column; align-items:center; justify-content:center;">
<?php if(!empty($data['site']['maintenance_image'])): ?>
<img src="<?= $data['site']['maintenance_image'] ?>" style="max-width:90%; max-height:400px; border-radius:12px; margin-bottom:30px; box-shadow: 0 10px 30px rgba(0,0,0,0.5);">
<?php else: ?>
<h1 style="font-size:60px; margin-bottom:20px;">🚧</h1>
<?php endif; ?>
<h2 style="margin-bottom:10px; color:<?= $data['site']['m_title_color'] ?? '#ffffff' ?>;"><?= htmlspecialchars($data['site']['m_title']) ?></h2>
<p style="color:<?= $data['site']['m_text_color'] ?? '#8b949e' ?>; max-width:400px; white-space:pre-wrap;"><?= htmlspecialchars($data['site']['m_text']) ?></p>
<?php if(($data['site']['show_login_link']??'on')==='on'): ?>
<div style="margin-top:50px; opacity:0.3;">
<a href="?page=login" style="color:white; font-size:10px; text-decoration:none;">Login</a>
</div>
<?php endif; ?>
</div>

<?php elseif($page === 'login'): ?>
<div style="max-width:300px; margin: 100px auto; padding: 20px; background:#161b22; border-radius:12px; border:1px solid #30363d; color:white;">
<h2 style="text-align:center; margin-bottom:20px;">Login</h2>
<?php if(isset($login_error)): ?>
<div style="color:#da3633; font-size:12px; margin-bottom:10px;"><?= $login_error ?></div>
<?php endif; ?>
<form method="post">
<input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
<label>User</label>
<input type="text" name="user" required>
<label>Pass</label>
<input type="password" name="pass" required>
<button type="submit" name="login" class="btn btn-save" style="width:100%; margin-top:10px;">Login</button>
</form>
</div>

<?php else: ?>
<div class="public-view">
<div class="bg-overlay"></div>
<div class="container">
<div class="profile">
<?php if(!empty($data['site']['profile_image'])): ?>
<img src="<?= $data['site']['profile_image'] ?>" class="profile-img">
<?php endif; ?>
<h1 style="color: <?= $data['site']['profile_name_color'] ?? '#000000' ?>;"><?= htmlspecialchars($data['site']['name']) ?></h1>
<div style="font-size:15px; color:<?= $data['site']['profile_desc_color'] ?? '#000000' ?>; font-weight:600; line-height:1.7; white-space:pre-wrap; text-align:center;">
<?= htmlspecialchars($data['site']['description']) ?>
</div>
</div>

<?php if(!empty($data['tweets'])): ?>
<div class="tweet-box">
<span style="font-size:16px; font-weight:bold; color:var(--theme); margin-bottom:10px; display:block;">
<?= htmlspecialchars($data['site']['tweet_title']) ?>
</span>
<?php 
$count = $data['site']['tweet_count'] ?? 1; 
$display_tweets = array_slice(array_reverse($data['tweets']), 0, $count); 
$total = count($display_tweets); 
foreach ($display_tweets as $index => $tw): 
?>
<div style="margin-bottom:<?= $index < $total - 1 ? '15px' : '0' ?>; padding-bottom:<?= $index < $total - 1 ? '15px' : '0' ?>; border-bottom:<?= $index < $total - 1 ? '1px solid rgba(255,255,255,0.1)' : 'none' ?>;">
<div style="font-size:11px; opacity:0.7; margin-bottom:5px;"><?= date('Y/m/d H:i', $tw['timestamp'] ?? time()) ?></div>
<?= nl2br(autoLinkUrls($tw['content'])) ?>
</div>
<?php endforeach; ?>
</div>
<?php endif; ?>

<div class="links">
<?php foreach ($data['links'] as $l): 
$acc = $l['accent_color'] ?: $data['site']['theme_color']; 
$hasMainUrl = !empty($l['url']) && $l['url'] !== '#'; 
?>
<?php if($hasMainUrl): ?>
<a href="<?= htmlspecialchars($l['url']) ?>" target="_blank" class="link-item">
<?php else: ?>
<div class="link-item <?= $l['type'] !== 'triple_icon' ? 'no-link' : '' ?>">
<?php endif; ?>

<?php if($l['type']==='standard'): ?>
<div class="card-standard" style="--acc:<?= $acc ?>">
<div class="link-icon">
<?php if(strpos($l['icon']??'','uploads/')===0): ?>
<img src="<?= $l['icon'] ?>" style="width:100%;height:100%;object-fit:contain;">
<?php else: 
echo $l['emoji'] ?: ($l['icon'] ?: '🔗'); 
endif; ?>
</div>
<div style="font-weight:bold;"><?= htmlspecialchars($l['title']) ?></div>
</div>

<?php elseif($l['type']==='triple_icon'): ?>
<div class="triple-icon-container">
<?php for($i=1; $i<=3; $i++): 
$iconKey = 'triple_icon'.$i;
$titleKey = 'triple_title'.$i;
$urlKey = 'triple_url'.$i;
if(!empty($l[$iconKey])): 
	$hasUrl = !empty($l[$urlKey]) && $l[$urlKey] !== '#';
?>
	<?php if($hasUrl): ?>
	<a href="<?= htmlspecialchars($l[$urlKey]) ?>" target="_blank" class="triple-icon-item" style="cursor:pointer;">
	<?php else: ?>
	<div class="triple-icon-item" style="cursor:default;">
	<?php endif; ?>
		<img src="<?= $l[$iconKey] ?>">
		<?php if(!empty($l[$titleKey])): ?>
		<div class="triple-icon-title"><?= htmlspecialchars($l[$titleKey]) ?></div>
		<?php endif; ?>
	<?php if($hasUrl): ?>
	</a>
	<?php else: ?>
	</div>
	<?php endif; ?>
<?php endif; 
endfor; ?>
</div>

<?php else: ?>
<div style="position:relative;">
<img src="<?= $l[$l['type']==='normal_img'?'normal_image':'banner_image'] ?>" style="width:100%;display:block; transition: transform 0.3s ease;">
<?php if(!empty($l['title']) && (!isset($l['show_title']) || $l['show_title'] === 'on')): 
?>
<div class="image-title-overlay"><?= htmlspecialchars($l['title']) ?></div>
<?php endif; ?>
</div>
<?php endif; ?>

<?php if($hasMainUrl): ?>
</a>
<?php else: ?>
</div>
<?php endif; ?>
<?php endforeach; ?>
</div>

<div style="text-align:center; margin-top:50px; opacity:0.2; font-size:10px;">
© <?= date('Y') ?> <a href="https://blog.hot-pathos.com/" target="_blank" rel="noopener noreferrer" style="color:white; text-decoration:none;">HappyPaintWork</a>
<?php if(($data['site']['show_login_link']??'on')==='on'): ?>
<br><a href="?page=login" style="color:white;">Login</a>
<?php endif; ?>
</div>
</div>
</div>
<button id="back-to-top" onclick="window.scrollTo({top:0, behavior:'smooth'})">▲</button>
<?php endif; ?>

<script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js"></script>
<script>
function u(v){
	const b1=document.getElementById('b1'),
		  b2=document.getElementById('b2'),
		  b3=document.getElementById('b3'),
		  b4=document.getElementById('b4'),
		  b5=document.getElementById('b5'),
		  common=document.getElementById('common_fields'),
		  titleOption=document.getElementById('title_display_option');  // ← この行があるか
	
	if(b1) b1.style.display=(v==='standard'?'block':'none'); 
	if(b2) b2.style.display=(v==='normal_img'?'block':'none'); 
	if(b3) b3.style.display=(v==='banner'?'block':'none'); 
	if(b4) b4.style.display=(v==='standard'?'block':'none');
	if(b5) b5.style.display=(v==='triple_icon'?'block':'none');
	if(common) common.style.display=(v==='triple_icon'?'none':'block');
	
	if(titleOption) {
		titleOption.style.display=(v==='normal_img' || v==='banner'?'block':'none');
	}
}
function resetAccentColor() { 
	document.getElementById('l_accent').value = "<?= $data['site']['theme_color'] ?>"; 
}
function editLink(data) {
	document.getElementById('l_id').value = data.id || '';
	document.getElementById('l_type').value = data.type || 'standard';
	document.getElementById('l_title').value = data.title || '';
	document.getElementById('l_url').value = data.url || '';
	document.getElementById('l_emoji').value = data.emoji || '';
	document.getElementById('l_accent').value = data.accent_color || "<?= $data['site']['theme_color'] ?>";
	document.getElementById('l_show_title').value = data.show_title || 'on';  // ← この行を追加
	document.getElementById('l_reset_btn').style.display = 'block';
	
	document.getElementById('triple_title1').value = data.triple_title1 || '';
	document.getElementById('triple_title2').value = data.triple_title2 || '';
	document.getElementById('triple_title3').value = data.triple_title3 || '';
	document.getElementById('triple_url1').value = data.triple_url1 || '';
	document.getElementById('triple_url2').value = data.triple_url2 || '';
	document.getElementById('triple_url3').value = data.triple_url3 || '';
	
	if (data.icon && data.icon.indexOf('uploads/') === 0) {
		document.getElementById('current_icon').textContent = '現在: ' + data.icon.split('/').pop();
	} else {
		document.getElementById('current_icon').textContent = '';
	}
	
	if (data.normal_image) {
		document.getElementById('current_normal_img').textContent = '現在: ' + data.normal_image.split('/').pop();
	} else {
		document.getElementById('current_normal_img').textContent = '';
	}
	
	if (data.banner_image) {
		document.getElementById('current_banner_img').textContent = '現在: ' + data.banner_image.split('/').pop();
	} else {
		document.getElementById('current_banner_img').textContent = '';
	}
	
	if (data.triple_icon1) {
		document.getElementById('current_triple1').textContent = '現在: ' + data.triple_icon1.split('/').pop();
	} else {
		document.getElementById('current_triple1').textContent = '';
	}
	
	if (data.triple_icon2) {
		document.getElementById('current_triple2').textContent = '現在: ' + data.triple_icon2.split('/').pop();
	} else {
		document.getElementById('current_triple2').textContent = '';
	}
	
	if (data.triple_icon3) {
		document.getElementById('current_triple3').textContent = '現在: ' + data.triple_icon3.split('/').pop();
	} else {
		document.getElementById('current_triple3').textContent = '';
	}
	
	u(data.type);
	window.scrollTo({top:0, behavior:'smooth'});
}
function resetLinkForm() {
	document.getElementById('link_form').reset();
	document.getElementById('l_id').value = '';
	document.getElementById('l_show_title').value = 'on'; 
	document.getElementById('l_reset_btn').style.display = 'none';
	document.getElementById('current_icon').textContent = '';
	document.getElementById('current_normal_img').textContent = '';
	document.getElementById('current_banner_img').textContent = '';
	document.getElementById('current_triple1').textContent = '';
	document.getElementById('current_triple2').textContent = '';
	document.getElementById('current_triple3').textContent = '';
	document.getElementById('l_type').value = 'standard';
	u('standard');
}
function editTweet(data) { 
	document.getElementById('t_id').value = data.id; 
	document.getElementById('t_content').value = data.content; 
	document.getElementById('t_reset_btn').style.display = 'block'; 
	window.scrollTo({top:0, behavior:'smooth'}); 
}
function resetTweetForm() { 
	document.getElementById('t_id').value = ''; 
	document.getElementById('t_content').value = ''; 
	document.getElementById('t_reset_btn').style.display = 'none'; 
}
const el = document.getElementById('sortable-links'); 
if (el) { 
	Sortable.create(el, { 
		handle: '.handle', 
		animation: 150, 
		onEnd: function() { 
			const order = Array.from(el.querySelectorAll('.sort-item')).map(item => item.dataset.id); 
			const fd = new FormData(); 
			fd.append('csrf_token', '<?php echo $_SESSION['csrf_token']; ?>'); 
			fd.append('new_order', order.join(',')); 
			fetch('', { method: 'POST', body: fd }); 
		} 
	}); 
}
window.onscroll = function() { 
	const btn = document.getElementById('back-to-top'); 
	if (btn) { 
		if (window.pageYOffset > 200) { 
			btn.classList.add('show'); 
		} else { 
			btn.classList.remove('show'); 
		} 
	} 
};
</script>
</body>
</html>